# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # First round: Cooperate
    
    # Check if opponent's code is deterministic and always cooperates
    if "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower():
        if len(my_history) % 3 == 0:  # Exploit every 3rd round
            return "D"
        else:
            return "C"
    
    # Check if opponent's code is deterministic and always defects
    if "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower():
        return "D"
    
    # If opponent defected last round, retaliate with tit-for-tat
    if opp_history[-1] == "D":
        return "D"
    
    # If opponent cooperated last round, continue cooperating unless testing
    if len(my_history) >= 8:  # Last 2 rounds
        if "D" in opp_history:  # If opponent has defected before
            return "D"
        else:
            return "C"
    
    # If mutual cooperation, occasionally test with a defect
    if len(my_history) >= 3 and all(m == "C" for m in opp_history[-3:]):
        if len(my_history) % 5 == 0:  # Test every 5th round
            return "D"
    
    # Default to cooperation
    return "C"